<?php

namespace FirstpointCh\Shop\Cart;

use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Region;
use Illuminate\Support\Collection;

interface CartDriver
{
    public function instance(): CartDriver;

    public function getCartIdentifier();

    public function getRegion(): Region;

    public function get(string $reference);

    public function content(): Collection;

    public function add(string $reference, string $name, float $price, ?int $quantity = 1, ?array $options = []);

    public function update(string $itemId, array $data);

    public function increment(string $reference, ?int $quantity = 1);

    public function decrement(string $reference, ?int $quantity = 1);

    public function remove(string $reference);

    public function destroy();

    public function getSubtotal(): float;

    public function getTaxes(): Collection;

    public function getTotal(): float;

    public function shippingAddressIsValid(): bool;

    public function shippingMethodIsValid(): bool;

    public function paymentMethodIsValid(): bool;

    public function getShippingAddress(): array;

    public function setShippingAddress($firstName, $lastName, $company, $street, $streetNumber, $zip, $city, $country, $vatNumber = null, $registrationNumber = null, $hasBillingAddress = false);

    public function getBillingAddress(): array;

    public function setBillingAddress($firstName, $lastName, $street, $streetNumber, $zip, $city, $country, $vatNumber = null, $registrationNumber = null, $company = null);

    public function getShippingMethod(): ?string;

    public function setShippingMethod(string $shippingMethod);

    public function getPaymentMethod(): ?string;

    public function setPaymentMethod(string $paymentMethod);

    public function setOrder(Order $order);
}
