<?php

namespace FirstpointCh\Shop\Cart;

use Illuminate\Support\Facades\Facade;

/**
 * @method static CartDriver driver(string $driver = null)
 * @method static load($identifier = null)
 * @method static get(string $reference)
 * @method static add(string $reference, string $name, float $price, ?int $quantity = 1, ?array $options = [])
 * @method static update(string $reference, array $data)
 * @method static increment(string $reference, ?int $quantity = 1)
 * @method static decrement(string $reference, ?int $quantity = 1)
 * @method static remove(string $reference)
 * @method static destroy()
 * @method static getSubtotal(): float
 * @method static getTaxes(): \Illuminate\Support\Collection
 * @method static getTotal(): float
 * @method static shippingAddressIsValid(): bool
 * @method static shippingMethodIsValid(): bool
 * @method static paymentMethodIsValid(): bool
 * @method static setShippingAddress(array $address)
 * @method static setBillingAddress(array $address)
 * @method static setShippingMethod(string $method)
 * @method static setPaymentMethod(string $method)
 *
 * @see CartManager
 */
class Cart extends Facade
{
    protected static function getFacadeAccessor()
    {
        return CartManager::class;
    }
}
