<?php

namespace FirstpointCh\Shop\Attribute;

use FirstpointCh\Shop\Models\Attribute;
use Illuminate\Support\Facades\Cache;

class AttributeValue
{
    public $id;

    public $key;

    public $name;

    public $value;

    public $type;

    public $options;

    public $translatable;

    public function __construct($value, $key)
    {
        $attribute = Cache::rememberForever('attributes', function () {
            return Attribute::with('options')->get()->keyBy('key');
        })->get($key) ?? new Attribute();

        $this->id = $attribute->id;
        $this->key = $key;
        $this->name = $attribute->name;
        $this->value = $value;
        $this->type = $attribute->type;
        $this->options = $attribute->options;
        $this->translatable = $attribute->translatable;
    }

    public function __toString()
    {
        return $this->localized(app()->getLocale());
    }

    public function localized($locale)
    {
        if ($this->type === 'options') {
            return $this->options->firstWhere('id', $this->value)->value ?? '';
        }

        if (is_string($this->value) || is_numeric($this->value)) {
            return $this->value ?? '';
        }

        if ($this->translatable) {
            return $this->value[$locale] ?? $this->value[config('app.fallback_locale')] ?? '';
        }

        return json_encode($this->value);
    }
}
