<?php

namespace FirstpointCh\Shop\Actions\Asset;

use FirstpointCh\Shop\Models\Asset;
use Illuminate\Support\Facades\Storage;

class RefreshFromDisk
{
    public function run(string $disk)
    {
        $files = collect(Storage::disk($disk)->allFiles());

        $assetPaths = Asset::where('disk', $disk)->pluck('path');

        // Delete assets that no longer exist on disk
        foreach ($assetPaths as $path) {
            if (! $files->contains($path)) {
                Asset::where('path', $path)->delete();
            }
        }

        foreach ($files as $path) {
            if (! $assetPaths->contains($path)) {
                Asset::create([
                    'disk' => $disk,
                    'path' => $path,
                    'mime_type' => Storage::disk($disk)->mimeType($path),
                    'size' => Storage::disk($disk)->size($path),
                    'display_name' => null,
                    'alt_text' => null,
                ]);
            } else {
                $asset = Asset::where('disk', $disk)->where('path', $path)->first();

                $asset->update([
                    'mime_type' => Storage::disk($disk)->mimeType($path),
                    'size' => Storage::disk($disk)->size($path),
                    'conversions' => $asset->conversions?->filter(
                        fn ($conversion, $name) => Storage::disk(config('shop.media_conversion_disk'))->exists($conversion)
                    ),
                ]);
            }
        }
    }
}
