# Variants

A variant is a specific version of a product. For example, a t-shirt might have variants for small, medium, and large, and each variant might have a different price.

Variants are orderable, they are the actual products that can be purchased.

## Variant model

- name
- slug
- sku
- is_active
- is_shippable
- weight_grams
- track_stock
- stock
- product_id

It also has some relations:

- Product (BelongsTo)
- Attributes (BelongsToMany)
- Regions (BelongsToMany): Prices are saved in the pivot table.

## Querying Variants

### Global scopes

When the shop is "region aware", an Eloquent global scope is applied to the `Variant` model to only return variants that are available in the current region.

### Filter variants

The variant model has some utility scopes to filter variants. Here some examples:

```php
$variants = Variant::query()
    ->active() // Get only active variants
    ->active(false) // Get only inactive variants
    ->wherePriceBetween(10, 100) // Filter by price
    // TODO: Add more filters
    ->get();
```

### Relation utilities

**Get variants prices**

```php
$variant = Variant::withPrice()->get();
$variant->price; // Get the price for the current region
```
