# Media

## Product pictures

Product pictures can be stored on any disk (remote or local) you want. The default disk is `public` and it is located in `storage/app/public`. You can change the default disk in the `config/shop.php` file. You should register your disks in the `config/filesystems.php` file first. Uploaded media will be converted to multiple sizes according to the `config/shop.php` file.

```php
// config/shop.php

'media' => [
    'product' => [
        'disk' => 'public',
        
        'conversions' => [
            'thumbnail' => [
                'width' => 200,
                'height' => 200,
            ],
        ],
    ],
],
```

## Regenerate all image conversions

```bash
php artisan media-library:regenerate
```
