<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('product_associations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->cascadeOnDelete();
            $table->foreignId('associated_product_id')->constrained('products')->cascadeOnDelete();
            $table->string('type'); // up-sell or cross-sell
            $table->timestamps();

            $table->unique(['product_id', 'associated_product_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('product_associations');
    }
};
