<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Truncate the carts table
        DB::table('carts')->delete();

        Schema::table('carts', function (Blueprint $table) {
            $table->dropColumn(['first_name', 'last_name', 'company', 'street', 'street_number', 'zip', 'city', 'country']);
        });

        Schema::table('carts', function (Blueprint $table) {
            $table->json('shipping_address')->after('address_id');
            $table->json('billing_address')->after('shipping_address');
        });
    }
};
