<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::table('carts')->delete();

        Schema::table('cart_items', function (Blueprint $table) {
            $table->string('reference')->after('cart_id');
            $table->decimal('unit_price')->before('quantity');
            $table->json('taxes')->nullable();

            $table->foreign('reference')->references('reference')->on('variants')->cascadeOnDelete();
        });

        Schema::table('cart_items', function (Blueprint $table) {
            $table->dropColumn(['orderable_type', 'orderable_id']);
        });
    }
};
