<?php

use FirstpointCh\Shop\Models\Category;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropForeign(['parent_id']);
        });

        Schema::table('categories', function (Blueprint $table) {
            $table->dropIndex('categories_parent_id_foreign');
        });

        Schema::table('categories', function (Blueprint $table) {
            $table->renameColumn('parent_id', 'parent_id_temp');
        });

        Schema::table('categories', function (Blueprint $table) {
            $table->foreignId('parent_id')->nullable()->constrained('categories')->onDelete('cascade');
        });

        Category::all()->each(function ($category) {
            $category->update([
                'parent_id' => $category->parent_id_temp,
            ]);
        });

        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn('parent_id_temp');
        });
    }
};
