<?php

use FirstpointCh\Shop\Models\Order;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('reference')->nullable()->after('id');
        });

        if (! app()->environment('testing')) {
            Order::all()->each->update(['reference' => Str::random(10)]);
        }

        Schema::table('orders', function (Blueprint $table) {
            $table->string('reference')->nullable(false)->unique()->change();
        });
    }
};
