<?php

use FirstpointCh\Shop\Models\CatalogIndex;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('catalog_index', function (Blueprint $table) {
            $table->string('variant_reference')->nullable()->after('variant_id');
        });

        if (! app()->environment('testing')) {
            CatalogIndex::all()->each(function (CatalogIndex $catalogIndex) {
                $catalogIndex->each(function ($item) {
                    $item->variant_reference = $item->variant->reference;
                    $item->save();
                });
            });
        }

        Schema::table('catalog_index', function (Blueprint $table) {
            $table->string('variant_reference')->nullable(false)->unique()->change();
        });
    }
};
