<?php

use FirstpointCh\Shop\Models\Variant;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('variants', function (Blueprint $table) {
            $table->string('reference')->nullable()->after('slug');
        });

        // if testing
        if (! app()->environment('testing')) {
            Variant::all()->each(function (Variant $variant) {
                $variant->reference = $variant->sku ?? $variant->slug ?? 'reference-'.$variant->id;
                $variant->save();
            });
        }

        Schema::table('variants', function (Blueprint $table) {
            $table->string('reference')->nullable(false)->index()->change();
        });
    }
};
