<?php

use FirstpointCh\Shop\Models\Product;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->json('slug')->nullable()->after('name');
        });

        if (! app()->environment('testing')) {
            foreach (Product::all() as $product) {
                $product->in('*');
                $slug = [];

                foreach ($product->name as $locale => $name) {
                    $slug[$locale] = Str::slug($name);
                }

                $product->update([
                    'slug' => $slug,
                ]);
            }
        }

        Schema::table('products', function (Blueprint $table) {
            $table->json('slug')->change();
        });
    }
};
