<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Variant;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class VariantFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Variant::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->word(),
            'sku' => strtoupper(Str::random(3)).'-'.strtoupper(Str::random(5)),
            'reference' => strtoupper(Str::random(3)).'-'.strtoupper(Str::random(5)),
            'is_active' => true,
            'track_stock' => false,
            'stock' => null,
            'slug' => $this->faker->word(),
            'is_shippable' => true,
            'weight_grams' => $this->faker->numberBetween(100, 1000),
            'product_id' => function () {
                return ProductFactory::new()->create();
            },
        ];
    }
}
