<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Order;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class OrderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Order::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'reference' => Str::random(10),
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->email(),
            'company' => $this->faker->company(),
            'street' => $this->faker->streetName(),
            'street_number' => $this->faker->streetSuffix(),
            'zip' => $this->faker->numberBetween(1000, 9999),
            'city' => $this->faker->city(),
            'country' => 'CH',
			'vat_number' => $this->faker->vat(),
			'registration_number' => $this->faker->companyNumber(),
            'billing_company' => null,
            'billing_street' => $this->faker->streetName(),
            'billing_street_number' => $this->faker->streetSuffix(),
            'billing_zip' => $this->faker->numberBetween(1000, 9999),
            'billing_city' => $this->faker->city(),
            'billing_country' => 'CH',
			'billing_vat_number' => $this->faker->vat(),
			'billing_registration_number' => $this->faker->companyNumber(),
            'shipping_method' => 'post-5',
            'payment_method' => 'testing',
            'amount' => $this->faker->numberBetween(100, 1000),
            'currency' => 'CHF',
            'status' => 'pending',
            'paid_at' => null,
            'customer_id' => function () {
                return Customer::factory()->create();
            },
            'region' => 'ch',
        ];
    }
}
