<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Address;
use FirstpointCh\Shop\Models\Customer;
use Illuminate\Database\Eloquent\Factories\Factory;

class AddressFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Address::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'company' => null,
            'street' => $this->faker->streetName(),
            'street_number' => $this->faker->streetSuffix,
            'zip' => $this->faker->postcode(),
            'city' => $this->faker->city(),
            'country' => 'CH',
            'customer_id' => function () {
                return Customer::factory()->create();
            },
			'vat_number' => $this->faker->vat(),
			'registration_number' => $this->faker->companyNumber()
        ];
    }
}
