<?php

return [

    /*
     * This is na array of all the languages available for the website.
     */
    'locales' => [
        'fr' => [
            'name' => 'Français',
            'base_path' => '/',
        ],
        'de' => [
            'name' => 'Deutsch',
            'base_path' => '/de',
        ],
    ],

    'regions' => [
        'ch' => [
            'name' => 'Suisse',
            'slug' => 'ch',
            'currency' => 'CHF',
            'currency_format' => 'de_CH',
            'countries' => [
                'CH',
            ],
        ],
    ],

    /*
     * The default region to use when the shop is "regions aware"
     */
    'default_region' => env('SHOP_DEFAULT_REGION', 'ch'),

    'middleware' => [
        'web' => [
            'web',
        ],
    ],

    'cp' => [
        'base_url' => '/cp',
        'guard' => 'cp',
    ],

    'api' => [
        'enabled' => false,
        'base_url' => '/shop/api',
    ],

    'cart_url' => '/cart',

    'payment_gateways' => [
        'default' => env('PAYMENT_GATEWAY_DRIVER', 'stripe-checkout'),

        'drivers' => [
            'stripe-checkout' => [
                'public_key' => env('STRIPE_PUBLIC_KEY'),
                'secret_key' => env('STRIPE_SECRET_KEY'),
                'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
            ],

            'test-gateway' => [],
        ],
    ],

    'carriers' => [
        'default' => \FirstpointCh\Shop\Carrier\DefaultCarrier::class,
    ],

    'media' => [
        'cms_assets' => [
            'title' => 'CMS Assets',
            'media_library' => true,
        ],

        'product_pictures' => [
            'title' => 'Product pictures',
            'media_library' => true,

            'conversions' => [
                'thumbnail' => [
                    'width' => 200,
                    'height' => 200,
                ],

                'small' => [
                    'width' => 400,
                    'height' => 400,
                ],

                'medium' => [
                    'width' => 800,
                    'height' => 800,
                ],
            ],
        ],
    ],

    'media_conversion_disk' => 'asset_conversions',

    'company' => [
        'name' => '',
        'street' => '',
        'street_number' => '',
        'zip' => '',
        'city' => '',
        'country' => '',
    ],

    /**
     * The invoice number pattern.
     * Available wildcards: {Y}, {M}, {D}, {#####}
     * when using {#####}, the number will be padded with zeros to the left to match the length of the wildcard.
     */
    'invoice_number_pattern' => 'LL{Y}-{######}',
];
