<?php

use Inertia\Testing\AssertableInertia;

it('shows the attribute create form', function () {
    $this->get('/cp/attributes/create')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Attribute/Form')
        );
});

test('the key is required', function () {
    $this->post('/cp/attributes')->assertStatus(302)->assertSessionHasErrors('key');
});

test('the name is required', function () {
    $this->post('/cp/attributes')->assertStatus(302)->assertSessionHasErrors('name');
});

test('the type is required', function () {
    $this->post('/cp/attributes')->assertStatus(302)->assertSessionHasErrors('type');
});

it('stores a new attribute', function () {
    $data = [
        'key' => 'name',
        'name' => ['en' => 'Name'],
        'type' => 'text',
    ];

    $this->post('/cp/attributes', $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/attributes');

    $data['name'] = json_encode($data['name']);

    $this->assertDatabaseHas('attributes', $data);
});
