<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Casts\Localized;
use Illuminate\Database\Eloquent\Model;

class CatalogIndex extends Model
{
    use HasPackageFactory;

    protected $table = 'catalog_index';

    protected $guarded = [];

    protected $casts = [
        'product_name' => Localized::class,
        'variant_name' => Localized::class,
        'product_categories' => 'array',
        'product_attributes' => 'json',
        'variant_attributes' => 'json',
    ];

    protected $keyType = 'string';

    public $incrementing = false;

    protected static function booted()
    {
        static::addGlobalScope('region-aware', function ($builder) {
            $builder->when(shop()->isRegionAware(), function ($query) {
                $query->where('region_id', shop()->getRegion()->id);
            });
        });
    }

    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variant()
    {
        return $this->belongsTo(Variant::class);
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function scopeOnRegion($query, $region)
    {
        $query->where('region_id', $region);
    }

    public function scopeActive($query, $region)
    {
        $query->where('product_status', 'published')->where('variant_is_active', true);
    }
}
