<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Attribute\AttributeValueCast;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;

class AttributeProduct extends Pivot
{
    use HasPackageFactory;

    protected $casts = [
        'value' => AttributeValueCast::class,
        'translatable' => 'boolean',
    ];

    public function attribute()
    {
        return $this->belongsTo(Attribute::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function option()
    {
        return $this->belongsTo(AttributeOption::class, 'value');
    }
}
