<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Models\Payment;
use LaravelDaily\Invoices\Classes\Buyer;
use LaravelDaily\Invoices\Classes\InvoiceItem;
use LaravelDaily\Invoices\Facades\Invoice;

class PaymentInvoiceController extends Controller
{
    public function show(Payment $payment)
    {
        $invoice = Invoice::make('Commande #'.$payment->order_id)
            ->status($payment->status->getLabel())
            ->sequence($payment->order_id)
            ->template('default-invoice')
            ->currencyCode($payment->currency)
            ->currencySymbol($payment->currency);

        $invoice->buyer(new Buyer([
            'name' => $payment->order->first_name.' '.$payment->order->last_name,
            'address' => $payment->order->street.' '.$payment->order->street_number.', '.$payment->order->zip.' '.$payment->order->city,
            'custom_fields' => [
                'email' => $payment->order->email,
            ],
        ]));

        foreach ($payment->order->items as $item) {
            $invoiceItem = (new InvoiceItem())
                ->title($item->name)
                ->description($item->sku)
                ->pricePerUnit($item->unit_price)
                ->quantity($item->quantity);

            if (! empty($item->total_tax_rate)) {
                $invoiceItem->taxByPercent($item->total_tax_rate);
            }

            $invoice->addItem($invoiceItem);
        }

        $invoice
            // ->discountByPercent(10)
            // ->taxRate(15)
            ->shipping($payment->order->shipping_price ?? 0);

        return $invoice->stream();
    }
}
