# Extend the CP

TODO: Make publishable stubs

## Introduction

You can extend the cp with custom pages. Pages are VueJS components that relie on InertiaJs.

## Getting started wth a custom page

Create a ```cp.js``` file in ```resources/js``` folder with the following content:

```js
import CustomPage from './Cp/CustomPage.vue';

Shop.registerPage('CustomPage', CustomPage)
```

Create the ```resources/js/Cp/CustomPage.vue``` component:

```vue
<template>
    <div>It Works !</div>
</template>
```

Add the script to ```vite.config.js```

```js
export default defineConfig({
    plugins: [
        laravel([
            // ...
            'resources/js/cp.js',
        ]),
        // ...
    ]
})
```

Inject the script in the cp from a service provider's boot method

```php
public function boot()
{
    app('shop::shop')->registerScripts([
        'resources/js/cp.js',
    ]);
}
```

Compile assets

```bash
npm run build
```

Create a ```routes/cp.php```. This file is detected and automatically loaded by the shop package. From there, you can create a route and return your inertia component.

```php
Route::get('/custom-page', function () {
    return inertia('TestComponent');
});
```

This page is available at ```https://yourstore.test/cp/custom-page```

## Attributes

You can extend the attributes with custom field types. To do this, you need to create a VueJS component and inject it within the ```cp.js``` file.

```js
import CustomFieldType from './Cp/CustomFieldType.vue';

Shop.registerFieldType('CustomFieldType', CustomFieldType)
```

Next you need to register a new Attribute in a service provider's boot method.

```php
public function boot()
{
    app('shop::shop')->registerAttributeType(
        label: 'Ma custom attribute type',
        fieldType: 'CustomFieldType',
    );
}
```

## Use Shop's built-in components

Shop provides a set of components that you can use in your custom pages and field types.

### Import components from the library

Add the following resolver alias to your vite.config.js file:

```js
export default defineConfig({
    // ...
    resolve: {
        alias: {
            '@shop': './vendor/firstpoint-ch/shop/dist/cp-lib.mjs',
        },
    },
});
```

Then you can import the components from the library:

```vue
<script setup>
import { Card, Button } from '@shop'
</script>
```

### Available components

- Button
- Card
- CardHead
- Datatable
- FileUpload
- FormField
- InputGroup
- Page
- Password
- Select
- Tags
- Textarea
- Tiptap
