# Payment

## Register a payment method

Open the ```shop```config file and find the ```payment_methods``` array. From here you can enable gateways by adding the corresponding class with their configuration.

```php
'payment_gateways' => [
    \FirstpointCh\Shop\Payment\Gateway\TestGateway::class => [
        'slug' => 'test-gateway',
    ],
    \FirstpointCh\Shop\Payment\Gateway\StripeCheckoutGateway::class => [
        'slug' => 'stripe-checkout',
        'public_key' => env('STRIPE_PUBLIC_KEY'),
        'secret_key' => env('STRIPE_SECRET_KEY'),
        'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
    ],
],
```

## Create a customer payment gateway

To create a new payment gateway, you need to create a new class that extends the ```FirstpointCh\Shop\Payment\Gateway\PaymentGateway``` class. The class needs to implement 3 methods:
- ```redirect```: This method is called to redirect the user to the payment gateway. You can also redirect the user to a payment form.
- ```fromRequest```: This method is responsible to find the payment based on the request.
- ```handle```: This method validates the payment and return a ```FirstpointCh\Shop\Payment\Enums\GatewayStatus```

You also need to set some properties:
- ```slug```: The slugified name of the payment gateway. This is used in url to identify the payment gateway.
- ```name```: The name of the payment gateway. Thi will be displayed to the user.
- ```description```: The description of the payment gateway. This will be displayed to the user.
- ```handleMode```: This can be "online" or "offline" and is used to determine if the request we get back is statefull (we know the authenticated user) ou stateless (server-to-server).

## Offline handle mode

When offline handle mode is enabled, the cutomer is redirected to a waiting page after the payment until the payment is validated. Once done, the user is redirected to a success or error page.

> Important
> When the validation is done through a POST request (ex: webhook), you need to whitelist the URL from CSRF verification in the ```App\Http\Middleware\VerifyCsrfToken``` middleware.
> ```php
> protected $except = [
>     '/shop/payment/stripe-checkout/handle',
> ];
> ```
> 