<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Models\OrderTax;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderTaxFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = OrderTax::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $taxableAmount = $this->faker->numberBetween(100, 300);
        $rate = $this->faker->numberBetween(10, 100);

        return [
            'order_id' => function () {
                return Order::factory()->create();
            },
            'name' => $this->faker->word(),
            'tax_included' => $this->faker->boolean,
            'taxable_amount' => $taxableAmount,
            'rate' => $rate,
            'tax_amount' => $taxableAmount * $rate / 100,
        ];
    }
}
