<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Product::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->word(),
            'short_description' => $this->faker->sentence(20),
            'description' => $this->faker->sentence(50),
            'status' => 'published',
            'product_type_id' => fn () => ProductTypeFactory::new()->create()->id,
        ];
    }
}
