<?php

namespace FirstpointCh\Shop\Traits;

use FirstpointCh\Shop\Models\CustomField;
use FirstpointCh\Shop\Models\CustomFieldModel;
use Illuminate\Database\Eloquent\Relations\MorphToMany;

trait HasCustomFields
{
    public function customFields(): MorphToMany
    {
        return $this->morphToMany(CustomField::class, 'model', 'custom_field_model')
            ->withPivot('value')
            ->withTimestamps()
            ->using(CustomFieldModel::class);
    }

    /**
     * Takes an updated array of serialized custom fields saves them to the model.
     */
    public function updateCustomFields(array $customFields)
    {
        return $this->customFields()->sync(collect($customFields)->mapWithKeys(fn ($customField) => [
            $customField['id'] => [
                'value' => $customField['pivot']['value'],
            ],
        ])->toArray());
    }
}
