<?php

namespace FirstpointCh\Shop\Data\Cp;

use FirstpointCh\Shop\Models\Attribute;
use Spatie\LaravelData\Data;

class DefaultProductAttributeData extends Data
{
    public function __construct(
        public int $attribute_id,
        public string $name,
        public string $type,
        public bool $translatable,
        public $options,
        public $component = null,
        public $value = null,
    ) {
    }

    public static function fromModel(Attribute $attribute): self
    {
        return new self(
            $attribute->id,
            $attribute->name,
            $attribute->type,
            $attribute->translatable,
            $attribute->options->map->in('*'),
            $attribute->type,
            $attribute->translatable
                ? [config('app.fallback_locale') => null]
                : null,
        );
    }
}
