<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tax_rules', function (Blueprint $table) {
            $table->id();
            $table->translatable('name');
            $table->translatable('description')->nullable();
            $table->decimal('rate');
            $table->boolean('tax_included');
            $table->boolean('apply_to_all_regions')->default(true);
            $table->boolean('apply_to_all_product_types')->default(true);
            $table->timestamps();
        });
    }
};
