<?php

use FirstpointCh\Shop\Models\ShippingMethod;
use Inertia\Testing\AssertableInertia;

it('shows the shipping method index', function () {
    $shippingMethod = ShippingMethod::factory()->create();

    $this->get('/cp/shipping-methods')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ShippingMethod/Index')
            ->has('shippingMethods.data', 1)
            ->where('shippingMethods.data.0.id', $shippingMethod->id)
        );
});

it('searches shipping method by name', function () {
    $firstShippingMethod = ShippingMethod::factory()->create([
        'name' => 'First method',
    ]);

    $secondShippingMethod = ShippingMethod::factory()->create([
        'name' => 'Second method',
    ]);

    datatableSearch('/cp/shipping-methods', 'First method')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ShippingMethod/Index')
            ->has('shippingMethods.data', 1)
            ->where('shippingMethods.data.0.id', $firstShippingMethod->id)
        );

    datatableSearch('/cp/shipping-methods', 'Second method')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ShippingMethod/Index')
            ->has('shippingMethods.data', 1)
            ->where('shippingMethods.data.0.id', $secondShippingMethod->id)
        );

    datatableSearch('/cp/shipping-methods', 'method')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ShippingMethod/Index')
            ->has('shippingMethods.data', 2)
        );
});
