<?php

use FirstpointCh\Shop\Models\Attribute;
use FirstpointCh\Shop\Models\ProductType;
use Inertia\Testing\AssertableInertia;

it('shows the product type create form', function () {
    $attribute = Attribute::factory()->create();

    $this->get('/cp/product-types/create')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ProductType/Form')
            ->has('availableAttributes', 1)
            ->where('availableAttributes.0.id', $attribute->id)
        );
});

it('creates a product type', function () {
    $attribute = Attribute::factory()->create();

    $data = [
        'name' => 'Test Product Type',
        'variantAttributes' => [
            $attribute->id,
        ],
        'productAttributes' => [
            $attribute->id,
        ],
    ];

    $this->post('/cp/product-types', $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/product-types');

    $this->assertDatabaseHas('product_types', [
        'name' => $data['name'],
    ]);

    $this->assertDatabaseHas('attribute_product_type', [
        'product_type_id' => ProductType::first()->id,
        'attribute_id' => $attribute->id,
        'type' => 'variant',
    ]);

    $this->assertDatabaseHas('attribute_product_type', [
        'product_type_id' => ProductType::first()->id,
        'attribute_id' => $attribute->id,
        'type' => 'product',
    ]);
});

it('shows the product type edit form', function () {
    $productType = ProductType::factory()->create();
    $attribute = Attribute::factory()->create();

    $this->get('/cp/product-types/'.$productType->id.'/edit')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ProductType/Form')
            ->has('availableAttributes', 1)
            ->whereAll([
                'availableAttributes.0.id' => $attribute->id,
                'attr.id' => $productType->id,
                'attr.name' => $productType->name,
            ])
        );
});

it('updates a product type', function () {
    $productType = ProductType::factory()->create();
    $productAttribute = Attribute::factory()->create();
    $variantAttribute = Attribute::factory()->create();
    $data = [
        'name' => 'Test Product Type',
        'productAttributes' => [$productAttribute->id],
        'variantAttributes' => [$variantAttribute->id],
    ];

    $this->post('/cp/product-types/'.$productType->id, $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/product-types');

    $this->assertDatabaseHas('product_types', [
        'name' => $data['name'],
    ]);

    $this->assertDatabaseHas('attribute_product_type', [
        'product_type_id' => ProductType::first()->id,
        'attribute_id' => $productAttribute->id,
        'type' => 'product',
    ]);

    $this->assertDatabaseHas('attribute_product_type', [
        'product_type_id' => ProductType::first()->id,
        'attribute_id' => $variantAttribute->id,
        'type' => 'variant',
    ]);
});
