<?php

use FirstpointCh\Shop\Models\Attribute;
use Illuminate\Support\Arr;
use Inertia\Testing\AssertableInertia;

it('shows the attribute edit form', function () {
    $attribute = Attribute::factory()->create();

    $this->get('/cp/attributes/'.$attribute->id.'/edit')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Attribute/Form')
            ->where('attr.id', $attribute->id)
        );
});

test('the key is required', function () {
    $attribute = Attribute::factory()->create();

    $this->post('/cp/attributes/'.$attribute->id)->assertStatus(302)->assertSessionHasErrors('key');
});

test('the name is required', function () {
    $attribute = Attribute::factory()->create();

    $this->post('/cp/attributes/'.$attribute->id)->assertStatus(302)->assertSessionHasErrors('name');
});

test('the type is required', function () {
    $attribute = Attribute::factory()->create();

    $this->post('/cp/attributes/'.$attribute->id)->assertStatus(302)->assertSessionHasErrors('type');
});

it('updates an attribute', function () {
    $attribute = Attribute::factory()->create([
        'key' => 'name',
        'name' => ['en' => 'Name'],
        'type' => 'text',
    ]);

    $data = [
        'key' => 'new_name',
        'name' => ['en' => 'New name'],
        'type' => 'translated',
        'options' => [
            ['value' => 'test'],
            ['value' => 'test 2'],
        ],
    ];

    $this->post('/cp/attributes/'.$attribute->id, $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/attributes');

    $data['name'] = json_encode($data['name']);
    Arr::pull($data, 'options');

    $this->assertDatabaseHas('attributes', $data);
    $this->assertDatabaseHas('attribute_options', [
        'attribute_id' => $attribute->id,
        'value' => json_encode([app()->getLocale() => 'test']),
    ]);
    $this->assertDatabaseHas('attribute_options', [
        'attribute_id' => $attribute->id,
        'value' => json_encode([app()->getLocale() => 'test 2']),
    ]);
});
