<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Region extends Model
{
    use HasPackageFactory, SoftDeletes;

    protected $guarded = [];

    protected $casts = [
        'available_countries' => 'array',
    ];

    public function variants()
    {
        return $this->belongsToMany(Variant::class, 'region_variant')
            ->withPivot(['price']);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }
}
