<?php

namespace FirstpointCh\Shop\Http\Controllers;

use FirstpointCh\Shop\Order\Enums\OrderStatus;
use FirstpointCh\Shop\Payment\Actions\PaymentIntentSuccessAction;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use FirstpointCh\Shop\Payment\Gateway;
use Illuminate\Http\Request;
use Log;

class HandlePaymentController extends Controller
{
    public function __construct(
        public Gateway $gatewayManager
    ) {
    }

    public function __invoke($gateway, Request $request)
    {
        try {
            $paymentGateway = $this->gatewayManager->fromRequest($gateway, $request);
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            abort(403, $e->getMessage());
        }

        match ($paymentGateway->handle($request)) {
            GatewayStatus::Success => PaymentIntentSuccessAction::run($paymentGateway->payment, OrderStatus::Pending),
            GatewayStatus::Authorized => PaymentIntentSuccessAction::run($paymentGateway->payment, OrderStatus::Paid),
            GatewayStatus::Charged => PaymentIntentSuccessAction::run($paymentGateway->payment, OrderStatus::Paid),
            GatewayStatus::Failed => $paymentGateway->payment->update(['status' => 'failed']),
            GatewayStatus::Error => $paymentGateway->payment->update(['status' => 'error']),
            GatewayStatus::Unknown => abort(403),
            default => abort(403),
        };

        if ($paymentGateway->handleMode === 'online') {
            return redirect()->route('shop::payment.confirmation', [
                'gateway' => $paymentGateway->slug,
                'reference' => $paymentGateway->payment->reference,
            ]);
        }

        return response()->noContent();
    }
}
