<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use Storage;
use FirstpointCh\Shop\Http\Controllers\Controller;
use Illuminate\Support\Str;

class UploadController extends Controller
{
    public function store()
    {
        $data = request()->validate([
            'files' => 'required|array',
            'files.*' => 'required|file|mimes:jpeg,png,jpg,gif,svg|max:4096',
        ]);

        $paths = [];

        foreach ($data['files'] as $file) {
            $paths[] = $file->store('/', config('shop.media.cms_assets.disk'));
        }

        return $paths;
    }
}
