<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Models\Cart;
use Inertia\Inertia;

class CartController extends Controller
{
    public function show(Cart $cart)
    {
        return Inertia::render('Cart/Show', [
            'cart' => $cart,
            'items' => $cart->items()->paginate(10),
        ]);
    }

    public function edit(Cart $cart)
    {
        return Inertia::render('Cart/Form', [
            'cart' => $cart,
        ]);
    }

    public function update(Cart $cart)
    {
        $data = request()->validate([]);

        $cart->update($data);

        // return redirect('/cp/users');
    }
}
