<?php

namespace FirstpointCh\Shop\Data\Query;

use Spatie\LaravelData\Data;

class ProductFilterData extends Data
{
    public function __construct(
        public ?string $status,
        public ?VariantFiltersData $variants,
    ) {
    }

    public static function fromArray(array $filters): static
    {
        return new static(
            $filters['status'] ?? null,
            VariantFiltersData::fromArray($filters['variants'] ?? []),
        );
    }
}
