import { createApp, h } from 'vue'
import { createInertiaApp, Link } from '@inertiajs/inertia-vue3'
import { InertiaProgress } from '@inertiajs/progress'
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers';
import Layout from '@/Shared/Layout.vue'
import Page from '@/Shared/Page.vue';

class Shop {
    constructor() {
        this.pages = {}
        this.fieldTypes = []
    }

    boot(app) {
        for (let page in this.pages) {
            app.component(page, this.pages[page])
        }

        for (let fieldType in this.fieldTypes) {
            app.component(fieldType, this.fieldTypes[fieldType])
        }
    }

    registerPage(name, page) {
        this.pages[name] = page
    }

    registerFieldType(name, component) {
        this.fieldTypes[name] = component
    }

    start() {
        createInertiaApp({
            resolve: name => {
                let page

                if (!! this.pages[name]) {
                    page = resolvePageComponent(name, this.pages)

                    page.then((page) => {
                        page.layout = page.layout || Layout;
                    })

                    return page
                } else {
                    page = resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob('./Pages/**/*.vue'))

                    page.then((module) => {
                        module.default.name = name;
                        module.default.layout = module.default.layout || Layout;
                    })
                }

                return page
            },

            setup({ el, App, props, plugin }) {
                const app = createApp({ render: () => h(App, props) })
                    .use(plugin)
                    .component('Page', Page)
                    .component('Link', Link)

                Object.entries(import.meta.glob('./Shared/Elements/*.vue', { eager: true })).forEach(([path, definition]) => {
                    app.component(path.split('/').pop().replace(/\.\w+$/, ''), definition.default);
                });

                app.mixin({
                    methods: {
                        money: (value, currency, format = 'ch-DE') => new Intl.NumberFormat(format, {
                            style: 'currency',
                            currency,
                        }).format(value)
                    }
                })

                window.Shop.boot(app)

                console.log(app)

                app.mount(el)
            },
        })
    }
}

InertiaProgress.init({ color: '#3730a3' });

window.Shop = new Shop();
