<?php

use FirstpointCh\Shop\Models\Brand;
use Inertia\Testing\AssertableInertia;

it('shows the brand edit form', function () {
    $brand = Brand::factory()->create();

    $this->get('/cp/brands/'.$brand->id.'/edit')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Brand/Form')
            ->where('brand.id', $brand->id)
        );
});

test('the name is required', function () {
    $brand = Brand::factory()->create();

    $this->post('/cp/brands/'.$brand->id)->assertStatus(302)->assertSessionHasErrors('name');
});

it('updates a brand', function () {
    $brand = Brand::factory()->create([
        'name' => 'Name',
    ]);

    $data = [
        'name' => 'New name',
    ];

    $this->post('/cp/brands/'.$brand->id, $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/brands');

    $this->assertDatabaseHas('brands', $data);
});
