<?php

namespace FirstpointCh\Shop;

use Illuminate\Support\Collection;

class Region
{
    public function __construct(
        public string $name,
        public string $slug,
        public string $currency,
        public string $currency_format,
        public array $countries,
    ) {
        //
    }

    public static function fromSlug($slug)
    {
        if (!config()->has("shop.regions.{$slug}")) {
            throw new \Exception('Invalid region "'.$slug.'"');
        }

        $region = config("shop.regions.{$slug}");

        return new Region(
            name: $region['name'],
            slug: $region['slug'],
            currency: $region['currency'],
            currency_format: $region['currency_format'],
            countries: $region['countries'],
        );
    }

    public static function all(): Collection
    {
        return collect(array_keys(config('shop.regions')))->map(function ($region) {
            return Region::fromSlug($region);
        });
    }

    public function __toString()
    {
        return $this->slug;
    }
}
