<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use Illuminate\Http\Request;

class BankTransferGateway extends PaymentGateway
{
    public string $slug = 'bank-transfer';

    public string $name = 'Bank transfer';

    public string $description = 'Bank transfer';

    public function fromRequest(Request $request): self
    {
        $this->payment = Payment::where('reference', $request->reference)->first();

        return $this;
    }

    public function redirect(?string $cancelUrl = null)
    {
        return redirect()
            ->route('shop::payment.handle', [
                'gateway' => $this->slug,
                'reference' => $this->payment->reference,
            ]);
    }

    public function handle(Request $request): GatewayStatus
    {
        if (empty($this->payment)) {
            return GatewayStatus::Unknown;
        }

        return GatewayStatus::Success;
    }
}
