<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;

class OrderTax extends Model
{
    use HasPackageFactory;

    protected $guarded = [];

    protected $casts = [
        'tax_include' => 'boolean',
        'taxable_amount' => 'float',
        'rate' => 'float',
        'tax_amount' => 'float',
    ];

    protected $appends = ['tax_amount_formatted'];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function apply($price)
    {
        if ($this->included) {
            return $price - ($price / (1 + $this->rate / 100));
        } else {
            return $price * $this->rate / 100;
        }
    }

    public function getTaxAmountFormattedAttribute()
    {
        return money()->format($this->tax_amount);
    }
}
