<?php

namespace FirstpointCh\Shop\Data\Cp;

use FirstpointCh\Shop\Models\Attribute;
use Spatie\LaravelData\Data;

class ProductFormData extends Data
{
    public function __construct(
        public array $name,
        public array $slug,
        public ?int $product_type_id = null,
        public ?string $status = 'draft',
        public ?array $short_description = null,
        public ?array $description = null,
        public ?array $base_attributes = [],
        public ?array $extra_attributes = [],
        public ?array $categories = [],
        public ?int $brand_id = null,
        public ?array $custom_fields = [],
        public ?array $meta_title = [],
        public ?array $meta_description = [],
    ) {
    }

    public static function rules(): array
    {
        return [
            'status' => 'nullable',
            'name.'.app()->getLocale() => 'required',
            'slug.'.app()->getLocale() => 'required',
            'short_description' => 'nullable',
            'description' => 'nullable',
            'product_type_id' => 'nullable|exists:product_types,id',
            'brand_id' => 'nullable|exists:brands,id',
            'base_attributes' => 'array',
            'base_attributes.*.attribute_id' => 'required|exists:attributes,id',
            'base_attributes.*.value' => 'nullable',
            'extra_attributes' => 'array',
            'extra_attributes.*.attribute_id' => 'required|exists:attributes,id',
            'extra_attributes.*.value' => 'nullable',
            'custom_fields' => 'nullable|array',
            'meta_title' => 'nullable|array',
            'meta_description' => 'nullable|array',
        ];
    }

    public function getProductData(): array
    {
        return [
            'status' => $this->status,
            'name' => $this->name,
            'slug' => $this->slug,
            'short_description' => $this->short_description,
            'description' => $this->description,
            'product_type_id' => $this->product_type_id,
            'brand_id' => $this->brand_id,
            'meta_title' => $this->meta_title,
            'meta_description' => $this->meta_description,
        ];
    }

    public function getAttributes(): array
    {
        $baseAttributes = collect($this->base_attributes)
            ->mapWithKeys(function ($attr) {
                $attribute = Attribute::find($attr['attribute_id']);

                return [
                    $attr['attribute_id'] => [
                        'value' => $attr['value'],
                        'type' => $attribute->type,
                        'translatable' => $attribute->translatable,
                    ],
                ];
            })->toArray();

        $extraAttributes = collect($this->extra_attributes)
            ->mapWithKeys(function ($attr) {
                $attribute = Attribute::find($attr['attribute_id']);

                return [
                    $attr['attribute_id'] => [
                        'value' => $attr['value'],
                        'type' => $attribute->type,
                        'translatable' => $attribute->translatable,
                    ],
                ];
            })->toArray();

        return $baseAttributes + $extraAttributes; // Merge but keep keys
    }
}
