<?php

namespace FirstpointCh\Shop\Attribute;

use FirstpointCh\Shop\Attribute\AttributeValue;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class AttributeValueCast implements CastsAttributes
{
    /**
     * Cast the given value.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array  $attributes
     * @return \App\ValueObjects\Address
     */
    public function get($model, $key, $value, $attributes)
    {
        $value = json_decode($value, true);

        return new AttributeValue($value, $attributes['type'], $attributes['translatable']);
    }

    /**
     * Prepare the given value for storage.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  \App\ValueObjects\Address  $value
     * @param  array  $attributes
     * @return array
     */
    public function set($model, $key, $value, $attributes)
    {
        return json_encode($value);
    }
}
