<?php

namespace FirstpointCh\Shop\Models;

use Illuminate\Database\Eloquent\Model;

class Price extends Model
{
    protected $table = 'region_variant';

    protected $guarded = [];

    protected $casts = [
        'price' => 'decimal:2',
    ];

    protected static function booted()
    {
        static::addGlobalScope('region-aware', function ($builder) {
            $builder->when(shop()->isRegionAware(), function ($query) {
                $query->where('region_id', shop()->getRegion()->id);
            });
        });
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function region()
    {
        return $this->belongsTo(Region::class);
    }
}
