<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Model;

class Attribute extends Model
{
    use HasPackageFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'translatable' => 'boolean',
        'option_value' => Localized::class,
    ];

    public function products()
    {
        return $this->belongsToMany(Product::class)
            ->withPivot(['type', 'value', 'translatable'])
            ->withTimestamps()
            ->using(AttributeProduct::class);
    }

    public function variants()
    {
        return $this->belongsToMany(Variant::class)
            ->withPivot(['type', 'value', 'translatable'])
            ->withTimestamps()
            ->using(AttributeVariant::class);
    }

    public function productTypes()
    {
        return $this->belongsToMany(ProductType::class)
            ->withTimestamps();
    }

    public function options()
    {
        return $this->hasMany(AttributeOption::class);
    }

    public function scopeWithBaseTypes($query)
    {
        return $query->whereIn('type', [
            'text',
            'number',
            'options',
            'wysiwyg',
        ]);
    }

    public function getDefaultValue()
    {
        return null;
        // return $this->type === 'translated'
        //     ? [config('app.fallback_locale') => null]
        //     : null;
    }
}
