<?php

namespace FirstpointCh\Shop\Collections;

use Illuminate\Database\Eloquent\Collection;

class CartTaxesCollection extends Collection
{
    public function included()
    {
        return $this->where('taxRule.tax_included', true);
    }

    public function excluded()
    {
        return $this->where('taxRule.tax_included', false);
    }

    public function total()
    {
        return $this->sum('tax_amount');
    }
}
