<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('CASCADE');
            $table->string('name');
            $table->string('sku')->index();
            $table->integer('quantity');
            $table->decimal('unit_price');
            $table->decimal('total_tax_rate', 5, 2)->nullable()->default('0.00');
            $table->string('status')->default('pending');
            $table->timestamps();
        });
    }
};
