<?php

use FirstpointCh\Shop\Models\Product;
use FirstpointCh\Shop\Models\ProductType;
use FirstpointCh\Shop\Models\TaxRule;

test('global taxes is applied', function () {
    $product = Product::factory()->create();

    $globalTax = TaxRule::factory()->create([
        'name' => 'global tax',
        'apply_to_all_channels' => true,
        'apply_to_all_product_types' => true,
    ]);

    $otherTax = TaxRule::factory()->create([
        'name' => 'other tax',
        'apply_to_all_channels' => false,
        'apply_to_all_product_types' => false,
    ]);

    $taxRules = TaxRule::forProduct($product)->get();

    $this->assertCount(1, $taxRules);
    $this->assertEquals('global tax', $taxRules->first()->name);
});

test('product type taxes is applied', function () {
    $product = Product::factory()->create([
        'product_type_id' => ProductType::factory()->create()->id,
    ]);

    $tax = TaxRule::factory()->create([
        'name' => 'product type tax',
        'apply_to_all_channels' => true,
        'apply_to_all_product_types' => false,
    ]);

    $product->productType->taxRules()->attach($tax);

    $taxRules = TaxRule::forProduct($product)->get();

    $this->assertCount(1, $taxRules);
    $this->assertEquals('product type tax', $taxRules->first()->name);
});

test('product taxes is applied', function () {
    $product = Product::factory()->create();

    $tax = TaxRule::factory()->create([
        'name' => 'product tax',
        'apply_to_all_channels' => true,
        'apply_to_all_product_types' => false,
    ]);

    $product->taxRules()->attach($tax);

    $taxRules = TaxRule::forProduct($product)->get();

    $this->assertCount(1, $taxRules);
    $this->assertEquals('product tax', $taxRules->first()->name);
});
