<?php

use FirstpointCh\Shop\Models\Channel;
use FirstpointCh\Shop\Models\ShippingMethod;
use Illuminate\Support\Collection;

it('belongs to many channels', function () {
    $shippingMethod = ShippingMethod::factory()->create();
    $channel = Channel::factory()->create();

    $shippingMethod->channels()->attach($channel, [
        'price' => 123,
    ]);

    $this->assertCount(1, $shippingMethod->channels);
    $this->assertInstanceOf(Collection::class, $shippingMethod->channels);
    $this->assertInstanceOf(Channel::class, $shippingMethod->channels->first());
    $this->assertEquals(123, $shippingMethod->channels()->first()->pivot->price);
});
